/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutWriter;
import org.netbeans.core.output2.ui.AbstractOutputPane;
import org.openide.util.Exceptions;

public class OutputDocument
implements Document,
Element,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(OutputDocument.class.getName());
    private List<DocumentListener> dlisteners = new ArrayList<DocumentListener>();
    private volatile Timer timer = null;
    private OutWriter writer;
    private StringBuffer inBuffer;
    private AbstractOutputPane pane;
    private int lastInputOff = -1;
    private char[] reusableSubrange = new char[256];
    private volatile DO lastEvent = null;
    private int lastFiredLineCount = 0;
    private int lastFiredLength = 0;
    private int lastVisibleLineCount = 0;

    OutputDocument(OutWriter outWriter) {
        if (Controller.LOG) {
            Controller.log("Creating a Document for " + outWriter);
        }
        this.writer = outWriter;
        this.getLines().addChangeListener(this);
        this.inBuffer = new StringBuffer();
    }

    OutWriter getWriter() {
        return this.writer;
    }

    public int getOutputLength() {
        return this.getLines().getCharCount();
    }

    public void setPane(AbstractOutputPane abstractOutputPane) {
        this.pane = abstractOutputPane;
    }

    public void dispose() {
        if (Controller.LOG) {
            Controller.log("Disposing document and backing storage for " + this.getLines().readLock());
        }
        this.disposeQuietly();
        this.writer.dispose();
        this.writer = null;
    }

    public void disposeQuietly() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.dlisteners.clear();
        this.lastEvent = null;
        this.getLines().removeChangeListener(this);
    }

    @Override
    public synchronized void addDocumentListener(DocumentListener documentListener) {
        this.dlisteners.add(documentListener);
        this.lastEvent = null;
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public Position createPosition(int n) throws BadLocationException {
        if (n < 0 || n > this.getLines().getCharCount() + this.inBuffer.length()) {
            throw new BadLocationException("Bad position", n);
        }
        return new ODPosition(n);
    }

    @Override
    public Element getDefaultRootElement() {
        return this;
    }

    @Override
    public Position getEndPosition() {
        return new ODEndPosition();
    }

    @Override
    public int getLength() {
        return this.getLines().getCharCount() + this.inBuffer.length();
    }

    @Override
    public Object getProperty(Object object) {
        return null;
    }

    @Override
    public Element[] getRootElements() {
        return new Element[]{this};
    }

    @Override
    public Position getStartPosition() {
        return new ODStartPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getText(int n, int n2) throws BadLocationException {
        String string;
        if (n2 == 0) {
            return "";
        }
        Object object = this.getLines().readLock();
        synchronized (object) {
            if (n < 0 || n + n2 > this.getLines().getCharCount() + this.inBuffer.length() || n2 < 0) {
                throw new BadLocationException("Bad: " + n + "," + n2 + " (" + this.getLines().getCharCount() + ", " + this.inBuffer.length() + ")", n);
            }
            int n3 = Math.min(this.getLines().getCharCount(), n);
            int n4 = Math.min(this.getLines().getCharCount(), n + n2);
            string = this.getLines().getText(n3, n4);
            if (n + n2 > this.getLines().getCharCount()) {
                int n5 = n + n2 - this.getLines().getCharCount();
                string = string + this.inBuffer.substring(0, n5);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        if (n2 < 0) {
            segment.array = new char[0];
            segment.offset = 0;
            segment.count = 0;
            return;
        }
        if (n < 0) {
            throw new BadLocationException("Negative offset", n);
        }
        if (this.getLines().getLineCount() == -1) {
            segment.array = new char[]{'\n'};
            segment.offset = 0;
            segment.count = 1;
            return;
        }
        if (n2 > this.reusableSubrange.length) {
            this.reusableSubrange = new char[n2];
        }
        try {
            Object object = this.getLines().readLock();
            synchronized (object) {
                int n3 = this.getLines().getCharCount();
                if (n3 < 0) {
                    segment.array = new char[0];
                    segment.offset = 0;
                    segment.count = 0;
                    return;
                }
                int n4 = Math.min(n3, n);
                int n5 = Math.min(n3, n + n2);
                char[] cArray = this.getLines().getText(n4, n5, this.reusableSubrange);
                if (n + n2 > n3) {
                    int n6 = n - n3 + n2;
                    int n7 = Math.max(0, n - n3);
                    this.inBuffer.getChars(Math.min(n7, this.inBuffer.length()), Math.min(n6, this.inBuffer.length()), cArray, n5 - n4);
                }
                segment.array = cArray;
                segment.offset = 0;
                segment.count = Math.min(n2, cArray.length);
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            OutWriter.lowDiskSpace = true;
            this.writer.dispose();
            Logger.getAnonymousLogger().log(Level.WARNING, "OOME while reading output.  Cleaning up.", outOfMemoryError);
            System.gc();
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        int n2;
        int n3 = this.getLength();
        int n4 = n3 - this.inBuffer.length();
        if (n4 != this.lastInputOff) {
            this.lastInputOff = n4;
            n2 = n3;
        } else {
            n2 = n < n4 ? n4 : n;
        }
        this.inBuffer.insert(n2 - n4, string);
        final int n5 = string.length();
        DocumentEvent documentEvent = new DocumentEvent(){

            @Override
            public int getOffset() {
                return n2;
            }

            @Override
            public int getLength() {
                return n5;
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.INSERT;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
        if (this.getLines() instanceof AbstractLines) {
            AbstractLines abstractLines = (AbstractLines)this.getLines();
            int n6 = abstractLines.getLineStart(abstractLines.getLineCount() - 1);
            int n7 = this.getLength() - n6;
            abstractLines.lineUpdated(2 * n6, 2 * n7, n7, false);
        }
        this.fireDocumentEvent(documentEvent);
    }

    public String sendLine() {
        final int n = this.getLength() - this.inBuffer.length();
        final int n2 = this.inBuffer.length();
        String string = this.inBuffer.toString();
        this.inBuffer = new StringBuffer();
        DocumentEvent documentEvent = new DocumentEvent(){

            @Override
            public int getOffset() {
                return n;
            }

            @Override
            public int getLength() {
                return n2;
            }

            @Override
            public Document getDocument() {
                return OutputDocument.this;
            }

            @Override
            public DocumentEvent.EventType getType() {
                return DocumentEvent.EventType.REMOVE;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
        if (this.getLines() instanceof AbstractLines) {
            AbstractLines abstractLines = (AbstractLines)this.getLines();
            int n3 = abstractLines.getLineStart(abstractLines.getLineCount() - 1);
            abstractLines.lineUpdated(2 * n3, 0, 0, false);
        }
        this.fireDocumentEvent(documentEvent);
        return string;
    }

    @Override
    public void putProperty(Object object, Object object2) {
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        int n3 = this.getLength() - this.inBuffer.length();
        final int n4 = Math.max(n3, n);
        final int n5 = Math.min(n2, this.inBuffer.length());
        if (n3 != this.lastInputOff) {
            this.lastInputOff = n3;
            this.inBuffer.delete(this.inBuffer.length() - n5, this.inBuffer.length());
        } else if (n4 - n3 + n5 <= this.getLength()) {
            this.inBuffer.delete(n4 - n3, n4 - n3 + n5);
            DocumentEvent documentEvent = new DocumentEvent(){

                @Override
                public int getOffset() {
                    return n4;
                }

                @Override
                public int getLength() {
                    return n5;
                }

                @Override
                public Document getDocument() {
                    return OutputDocument.this;
                }

                @Override
                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.REMOVE;
                }

                @Override
                public DocumentEvent.ElementChange getChange(Element element) {
                    return null;
                }
            };
            if (this.getLines() instanceof AbstractLines) {
                AbstractLines abstractLines = (AbstractLines)this.getLines();
                int n6 = abstractLines.getLineStart(abstractLines.getLineCount() - 1);
                int n7 = this.getLength() - n6;
                abstractLines.lineUpdated(2 * n6, 2 * n7, n7, false);
            }
            this.fireDocumentEvent(documentEvent);
        }
    }

    @Override
    public synchronized void removeDocumentListener(DocumentListener documentListener) {
        this.dlisteners.remove(documentListener);
        this.lastEvent = null;
        if (this.dlisteners.isEmpty() && this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public Lines getLines() {
        return this.writer != null ? this.writer.getLines() : null;
    }

    public int getLineStart(int n) {
        return this.getLines().getLineCount() > 0 ? this.getLines().getLineStart(n) : 0;
    }

    public int getLineEnd(int n) {
        if (this.getLines().getLineCount() == 0) {
            return 0;
        }
        int n2 = n >= this.getLines().getLineCount() - 1 ? this.getLines().getCharCount() + this.inBuffer.length() : this.getLines().getLineStart(n + 1) - 1;
        return n2;
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
    }

    @Override
    public void render(Runnable runnable) {
        this.getElementCount();
        runnable.run();
    }

    @Override
    public AttributeSet getAttributes() {
        return SimpleAttributeSet.EMPTY;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    @Override
    public Element getElement(int n) {
        int n2 = this.getLines().visibleToRealLine(n);
        return new ODElement(n2);
    }

    @Override
    public int getElementCount() {
        return Math.max(1, this.getLines().getVisibleLineCount());
    }

    @Override
    public int getElementIndex(int n) {
        int n2 = this.getLines().getLineAt(n);
        if (n2 < 0) {
            return n2;
        }
        return this.getLines().realToVisibleLine(n2);
    }

    @Override
    public int getEndOffset() {
        return this.getLength() + 1;
    }

    @Override
    public String getName() {
        return "foo";
    }

    @Override
    public Element getParentElement() {
        return null;
    }

    @Override
    public int getStartOffset() {
        return 0;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        assert (SwingUtilities.isEventDispatchThread());
        if (Controller.VERBOSE) {
            Controller.log(changeEvent != null ? "Document got change event from writer" : "Document timer polling");
        }
        if (this.dlisteners.isEmpty()) {
            if (Controller.VERBOSE) {
                Controller.log("listeners empty, not firing");
            }
            return;
        }
        Lines lines = this.getLines();
        if (lines.checkDirty(true)) {
            boolean bl;
            int n;
            int n2;
            int n3;
            if (this.lastEvent != null && !this.lastEvent.isConsumed()) {
                if (Controller.VERBOSE) {
                    Controller.log("Last event not consumed, not firing");
                }
                return;
            }
            Object object = lines.readLock();
            synchronized (object) {
                int n4;
                n3 = lines.getLineCount();
                n2 = lines.getVisibleLineCount();
                n = lines.getCharCount() + this.inBuffer.length();
                if (n == this.lastFiredLength && n2 == this.lastVisibleLineCount) {
                    if (Controller.VERBOSE) {
                        Controller.log("Size is same " + n + " - not firing");
                    }
                    return;
                }
                boolean bl2 = bl = this.lastFiredLineCount == n3;
                if (this.lastFiredLineCount > 0 && n3 > this.lastFiredLineCount && (n4 = lines.getLineStart(this.lastFiredLineCount)) > this.lastFiredLength) {
                    bl = true;
                }
            }
            this.lastEvent = this.lastFiredLineCount == n3 && this.lastVisibleLineCount != n2 ? new DO(0) : new DO(bl ? this.lastFiredLineCount - 1 : this.lastFiredLineCount);
            this.lastFiredLineCount = n3;
            this.lastVisibleLineCount = n2;
            this.lastFiredLength = n;
            if (Controller.VERBOSE) {
                Controller.log("Firing document event on EQ with start index " + this.lastEvent.first);
            }
            this.fireDocumentEvent(this.lastEvent);
            if (this.pane != null) {
                this.pane.getFoldingSideBar().repaint();
            }
        } else if (Controller.VERBOSE) {
            Controller.log("Writer says it is not dirty, firing no change");
        }
    }

    private void fireDocumentEvent(DocumentEvent documentEvent) {
        for (DocumentListener documentListener : new ArrayList<DocumentListener>(this.dlisteners)) {
            if (!(documentEvent instanceof DO) && this.pane != null) {
                this.pane.doUpdateCaret();
            }
            if (documentEvent.getType() == DocumentEvent.EventType.REMOVE) {
                documentListener.removeUpdate(documentEvent);
            } else if (documentEvent.getType() == DocumentEvent.EventType.CHANGE) {
                documentListener.changedUpdate(documentEvent);
            } else {
                documentListener.insertUpdate(documentEvent);
            }
            if (documentEvent instanceof DO || this.pane == null) continue;
            this.pane.dontUpdateCaret();
        }
    }

    public String toString() {
        return "OD@" + System.identityHashCode(this) + " for " + this.getLines().readLock();
    }

    static /* synthetic */ OutWriter access$200(OutputDocument outputDocument) {
        return outputDocument.writer;
    }

    public class DO
    implements DocumentEvent,
    DocumentEvent.ElementChange {
        private int offset = -1;
        private int length = -1;
        private int lineCount = -1;
        private boolean consumed = false;
        private int first = -1;

        DO(int n) {
            this.first = n;
            if (n < 0) {
                throw new IllegalArgumentException("Illogical start: " + n);
            }
        }

        private void calc() {
            assert (SwingUtilities.isEventDispatchThread()) : "Should be accessed from AWT only or we have a synchronization problem";
            if (!this.consumed) {
                this.consumed = true;
                OutputDocument.this.lastFiredLineCount = OutputDocument.this.getLines().getLineCount();
                OutputDocument.this.lastFiredLength = OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length();
                if (this.first < OutputDocument.this.lastFiredLineCount) {
                    this.offset = OutputDocument.this.getLines().getLineStart(this.first);
                    this.lineCount = OutputDocument.this.lastFiredLineCount - this.first;
                    this.length = OutputDocument.this.lastFiredLength - this.offset;
                } else {
                    this.lineCount = 0;
                    this.length = 0;
                    this.offset = 0;
                }
            }
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        public String toString() {
            boolean bl = this.isConsumed();
            this.calc();
            return "Event: first=" + this.first + " linecount=" + this.lineCount + " offset=" + this.offset + " length=" + this.length + " consumed=" + bl;
        }

        @Override
        public DocumentEvent.ElementChange getChange(Element element) {
            if (element == OutputDocument.this) {
                return this;
            }
            return null;
        }

        @Override
        public Document getDocument() {
            return OutputDocument.this;
        }

        @Override
        public int getLength() {
            this.calc();
            return this.length;
        }

        @Override
        public int getOffset() {
            this.calc();
            return this.offset;
        }

        @Override
        public DocumentEvent.EventType getType() {
            return this.first == 0 ? DocumentEvent.EventType.CHANGE : DocumentEvent.EventType.INSERT;
        }

        @Override
        public Element[] getChildrenAdded() {
            this.calc();
            if (this.first + this.lineCount > OutputDocument.this.getLines().getLineCount()) {
                LOG.log(Level.INFO, "Document line count: {0}, OD line count: {1}", new Object[]{OutputDocument.this.getLines().getLineCount(), this.first + this.lineCount});
                return new Element[0];
            }
            Element[] elementArray = new Element[this.lineCount];
            for (int i = 0; i < this.lineCount; ++i) {
                elementArray[i] = new ODElement(this.first + i);
            }
            return elementArray;
        }

        @Override
        public Element[] getChildrenRemoved() {
            return new Element[0];
        }

        @Override
        public Element getElement() {
            return OutputDocument.this;
        }

        @Override
        public int getIndex() {
            this.calc();
            return this.first;
        }
    }

    final class ODElement
    implements Element {
        private int lineIndex;
        private int startOffset = -1;
        private int endOffset = -1;

        ODElement(int n) {
            this.lineIndex = n;
        }

        public int hashCode() {
            return this.lineIndex;
        }

        public boolean equals(Object object) {
            return object instanceof ODElement && ((ODElement)object).lineIndex == this.lineIndex && ((ODElement)object).getDocument() == this.getDocument();
        }

        @Override
        public AttributeSet getAttributes() {
            return SimpleAttributeSet.EMPTY;
        }

        @Override
        public Document getDocument() {
            return OutputDocument.this;
        }

        @Override
        public Element getElement(int n) {
            return null;
        }

        @Override
        public int getElementCount() {
            return 0;
        }

        @Override
        public int getElementIndex(int n) {
            return -1;
        }

        @Override
        public int getEndOffset() {
            this.calc();
            return this.endOffset;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Element getParentElement() {
            return OutputDocument.this;
        }

        @Override
        public int getStartOffset() {
            this.calc();
            return this.startOffset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void calc() {
            Object object = OutputDocument.this.getLines().readLock();
            synchronized (object) {
                if (this.lineIndex < 0) {
                    return;
                }
                if (this.startOffset == -1) {
                    if (this.lineIndex >= OutputDocument.this.getLines().getLineCount()) {
                        this.startOffset = 0;
                        this.endOffset = 0;
                        return;
                    }
                    this.startOffset = OutputDocument.this.getLines().getLineStart(this.lineIndex);
                    this.endOffset = this.lineIndex >= OutputDocument.this.getLines().getLineCount() - 1 ? OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length() + 1 : OutputDocument.this.getLines().getLineStart(this.lineIndex + 1);
                    assert (this.endOffset >= this.startOffset) : "Illogical getLine #" + this.lineIndex + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", charCount=" + OutputDocument.this.getLines().getCharCount() + " with lines " + OutputDocument.this.getLines() + " or writer has been reset" + ". writer: " + (OutputDocument.access$200(OutputDocument.this) == null ? "is null" : "writer.isDisposed(): " + OutputDocument.access$200(OutputDocument.this).isDisposed() + ". writer.getStorage(): " + OutputDocument.access$200(OutputDocument.this).getStorage());
                } else if (this.lineIndex >= OutputDocument.this.getLines().getLineCount() - 1) {
                    this.endOffset = OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length() + 1;
                }
            }
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            try {
                return OutputDocument.this.getText(this.getStartOffset(), this.getEndOffset() - this.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return "";
            }
        }
    }

    final class ODStartPosition
    implements Position {
        ODStartPosition() {
        }

        @Override
        public int getOffset() {
            return 0;
        }

        private Document doc() {
            return OutputDocument.this;
        }

        public boolean equals(Object object) {
            return object instanceof ODStartPosition && ((ODStartPosition)object).doc() == this.doc();
        }

        public int hashCode() {
            return 2190481;
        }
    }

    final class ODEndPosition
    implements Position {
        ODEndPosition() {
        }

        @Override
        public int getOffset() {
            return OutputDocument.this.getLines().getCharCount() + OutputDocument.this.inBuffer.length();
        }

        private Document doc() {
            return OutputDocument.this;
        }

        public boolean equals(Object object) {
            return object instanceof ODEndPosition && ((ODEndPosition)object).doc() == this.doc();
        }

        public int hashCode() {
            return -2390481;
        }
    }

    static final class ODPosition
    implements Position {
        private int offset;

        ODPosition(int n) {
            this.offset = n;
        }

        @Override
        public int getOffset() {
            return this.offset;
        }

        public int hashCode() {
            return this.offset * 11;
        }

        public boolean equals(Object object) {
            return object instanceof ODPosition && ((ODPosition)object).getOffset() == this.offset;
        }
    }
}

