/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.site;

import com.jrockit.mc.ui.site.IServiceRegistry;
import com.jrockit.mc.ui.site.SelectionProviderActivator;
import com.jrockit.mc.ui.site.ServiceRegistry;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;

public class SectionSite
implements IServiceRegistry {
    private final IWorkbenchPartSite m_parentSite;
    private final SelectionProviderActivator m_selectionActivator;
    private final IServiceRegistry m_registry;
    private String m_id;

    public SectionSite(String id, IWorkbenchPartSite parentSite, IServiceRegistry registry) {
        this.m_parentSite = parentSite;
        this.m_id = id;
        this.m_selectionActivator = new SelectionProviderActivator(parentSite);
        this.m_registry = registry == null ? new ServiceRegistry() : registry;
    }

    public IServiceRegistry getServiceRegistry() {
        return this.m_registry;
    }

    public String getId() {
        return this.m_id;
    }

    public void activate() {
        this.m_selectionActivator.activate();
    }

    public void deactivate() {
        this.m_selectionActivator.deactivate();
    }

    public void dispose() {
        this.deactivate();
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider provider) {
        String id;
        String string = id = menuManager.getId() != null ? menuManager.getId() : this.getId();
        if (this.m_parentSite instanceof IEditorSite) {
            ((IEditorSite)this.m_parentSite).registerContextMenu(id, menuManager, provider, false);
        } else {
            this.m_parentSite.registerContextMenu(id, menuManager, provider);
        }
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.m_selectionActivator.setSelectionProvider(provider);
    }

    @Override
    public <T> T getService(Class<T> api) {
        return this.m_registry.getService(api);
    }

    @Override
    public boolean hasService(Class<?> api) {
        return this.m_registry.hasService(api);
    }

    @Override
    public <T> boolean registerService(Class<T> api, T serviceInstance) {
        return this.m_registry.registerService(api, serviceInstance);
    }

    @Override
    public IServiceRegistry getParent() {
        return this.m_registry.getParent();
    }

    public void setIdentifier(String identifier) {
        this.m_id = identifier;
    }
}

