/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.multichart;

import com.jrockit.mc.common.unit.UnitDescriptor;
import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageModel;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.multichart.Chart;
import com.jrockit.mc.flightrecorder.ui.components.multichart.ChartContentProvider;
import com.jrockit.mc.flightrecorder.ui.components.multichart.ChartTableViewer;
import com.jrockit.mc.flightrecorder.ui.components.multichart.ContentProviderBuilder;
import com.jrockit.mc.flightrecorder.ui.components.multichart.FieldChartLabelProvider;
import com.jrockit.mc.flightrecorder.ui.components.multichart.KeyImageBuilder;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.legend.LegendViewer;
import com.jrockit.mc.ui.fields.FieldViewerFilterControl;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.FieldFactory;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MultiChartComponent
extends AbstractUIComponent
implements ITypeVisibilityChange,
INavigatorSelectionChangeListener,
IOperativeSetAware,
ITypeVisibilitySupport {
    private ChartTableViewer m_viewer;
    private Field m_field;

    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            ViewModelBuilder<ChartContentProvider> builder = this.createModelBuilder();
            builder.setEventView(this.createView());
            builder.setOperativeSetEnabled(false);
            serviceLocator.registerService(ViewModelBuilder.class.getName(), builder);
            serviceLocator.registerService((Object)new OperativeSetService(serviceLocator));
            this.hookModelView(builder);
            this.m_field = FieldFactory.createFromDisplayUnit((UnitDescriptor)this.getChartDescriptor().getGroupBy().getUnit(), (String)"dummy", (int)0);
            return true;
        }
        return false;
    }

    private void hookModelView(final ViewModelBuilder<ChartContentProvider> builder) {
        builder.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                MultiChartComponent.this.updateView((ChartContentProvider)builder.getModel());
            }
        });
    }

    private ViewModelBuilder<ChartContentProvider> getModelBuilder() {
        return (ViewModelBuilder)this.getServiceLocator().getService(ViewModelBuilder.class.getName());
    }

    private void updateView(final ChartContentProvider chartContentProvider) {
        DisplayToolkit.safeAsyncExec((Display)this.m_viewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                MultiChartComponent.this.m_viewer.setLabelProvider(MultiChartComponent.this.createLabelProvider());
                MultiChartComponent.this.m_viewer.setContentProvider((IContentProvider)chartContentProvider);
                MultiChartComponent.this.m_viewer.refresh();
            }
        });
    }

    private IBaseLabelProvider createLabelProvider() {
        Canvas c = (Canvas)this.m_viewer.getControl();
        int width = c.getClientArea().width;
        int height = c.getClientArea().height;
        int maxCount = 2 * (height / this.m_viewer.getItemHeight());
        FieldChartLabelProvider fc = new FieldChartLabelProvider(width, this.m_viewer.getItemHeight(), maxCount, this.m_field);
        fc.addListener(new ILabelProviderListener(){
            private final Map<Object, ChartImageBuilder> m_builderMap = new HashMap<Object, ChartImageBuilder>();

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Chart tdp;
                ChartContentProvider cp = (ChartContentProvider)MultiChartComponent.this.m_viewer.getContentProvider();
                if (cp != null && (tdp = cp.getChart(event.getElement())) != null) {
                    ChartImageBuilder ib = this.m_builderMap.get(event.getElement());
                    if (ib == null) {
                        ib = MultiChartComponent.this.createImageBuilder((FieldChartLabelProvider)event.getSource(), tdp, event.getElement(), NLS.bind((String)Messages.MULTI_CHART_COMPONENT_IMAGE_BUILDER_NAME, (Object)event.getElement()));
                        this.m_builderMap.put(event.getElement(), ib);
                    }
                    ib.scheduleRebuild();
                }
            }
        });
        return fc;
    }

    private ChartImageBuilder createImageBuilder(final FieldChartLabelProvider provider, Chart chart, final Object element, String name) {
        final KeyImageBuilder ib = new KeyImageBuilder(this.getServiceLocator(), chart, this.getChartDescriptor(), name);
        ib.setSize(provider.getWidth(), provider.getHeight());
        ib.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                MultiChartComponent.this.updateImage(((ChartImageModel)ib.getModel()).getImage(), element, provider);
            }
        });
        IView view = this.createView();
        ib.setRange(this.getModelBuilder().getView().getRange());
        view.setRange(this.getModelBuilder().getView().getRange());
        view.setEventTypes(this.getModelBuilder().getView().getEventTypes());
        view.setOrder(EventOrder.ASCENDING);
        ib.setEventView(view);
        return ib;
    }

    private void updateImage(final Image image, final Object element, final FieldChartLabelProvider provider) {
        DisplayToolkit.safeAsyncExec((Widget)this.m_viewer.getControl(), (Runnable)new Runnable(){

            @Override
            public void run() {
                if (provider == MultiChartComponent.this.m_viewer.getLabelProvider()) {
                    provider.addImage(element, image);
                    MultiChartComponent.this.m_viewer.update();
                }
            }
        });
    }

    protected final IView createView() {
        return this.getFlightRecording().createView();
    }

    private ViewModelBuilder<ChartContentProvider> createModelBuilder() {
        return new ContentProviderBuilder(this.getServiceLocator(), this.getChartDescriptor(), this.getComponentDescriptor().getName());
    }

    private FLRChartDescriptor getChartDescriptor() {
        return (FLRChartDescriptor)((Object)this.getComponentDescriptor().getComponentSettings().getChildObject("chartDescriptor", FLRChartDescriptor.class));
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    public Control createPart(Composite parent) {
        int columnCount = 0;
        Composite container = this.getFormToolkit().createComposite(parent);
        if (this.isFilterable()) {
            GridData gd1 = new GridData(4, 4, false, false);
            gd1.widthHint = this.getChartDescriptor().getGroupBy().getWidth();
            FieldViewerFilterControl filter = new FieldViewerFilterControl(container, this.getFormToolkit(), false);
            filter.initialize((StructuredViewer)this.m_viewer, new Field[]{this.m_field});
            filter.setFilteredField(this.m_field);
            filter.setLayoutData((Object)gd1);
            ++columnCount;
        }
        if (this.hasLegends()) {
            GridData gd2 = new GridData(4, 4, true, false);
            LegendViewer legendViewer = this.createLegendViewer(container, this.getFormToolkit());
            legendViewer.getControl().setLayoutData((Object)gd2);
            ++columnCount;
        }
        if (this.isOperativeSettable()) {
            GridData gd4 = new GridData(4, 4, false, false);
            gd4.horizontalIndent = 5;
            Button checkBox = this.createOperativeSetButton(container);
            checkBox.setLayoutData((Object)gd4);
            ++columnCount;
        }
        if (columnCount == 0) {
            columnCount = 1;
        }
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = columnCount;
        this.m_viewer = new ChartTableViewer(this.getFormToolkit(), container, this.getChartDescriptor().getChartHeight(), this.getChartDescriptor().getGroupBy().getWidth());
        this.m_viewer.setContentProvider((IContentProvider)new ChartContentProvider(this.getChartDescriptor()));
        this.m_viewer.setLabelProvider(this.createLabelProvider());
        this.m_viewer.getControl().setLayoutData((Object)gd3);
        this.hookResizeListener((Canvas)this.m_viewer.getControl());
        container.setLayout((Layout)new GridLayout(columnCount, false));
        return container;
    }

    private boolean isFilterable() {
        return this.getChartDescriptor().getGroupBy().isFilterable();
    }

    protected final boolean hasLegends() {
        return this.getChartDescriptor().getLegendDescriptors().size() > 0;
    }

    protected final boolean isOperativeSettable() {
        return this.getChartDescriptor().getGroupBy().getAllowOperativeSet();
    }

    protected final Button createOperativeSetButton(Composite topControl) {
        final Button checkBox = this.getFormToolkit().createButton(topControl, Messages.OPERATIVE_SET_SHOW_ONLY_SET_BUTTON_TEXT, 32);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiChartComponent.this.getModelBuilder().setOperativeSetEnabled(checkBox.getSelection());
                MultiChartComponent.this.getModelBuilder().scheduleRebuild();
            }
        });
        return checkBox;
    }

    private LegendViewer createLegendViewer(Composite parent, FormToolkit formToolkit) {
        LegendViewer viewer = new LegendViewer(parent, formToolkit);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider((ChartDescriptor)this.getChartDescriptor(), parent.getDisplay(), 8));
        viewer.setInput((Object)this.getChartDescriptor().getLegendDescriptors());
        return viewer;
    }

    private void hookResizeListener(Canvas control) {
        control.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                MultiChartComponent.this.getModelBuilder().scheduleRebuild();
            }
        });
    }

    protected void refresh() {
        this.m_viewer.refresh();
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    protected void initializeUI() {
        TimeRange fullRange = new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp());
        this.getModelBuilder().getView().setRange((ITimeRange)fullRange);
        this.m_viewer.setInput((Object)this.getChartDescriptor());
    }

    @Override
    public void operativeSetChange() {
        this.getModelBuilder().scheduleRebuild();
    }

    @Override
    public void onChange(long startTime, long endTime) {
        this.getModelBuilder().getView().setRange((ITimeRange)new TimeRange(startTime, endTime));
        this.getModelBuilder().scheduleRebuild();
    }

    @Override
    public boolean isTypeChangeEnabled() {
        return false;
    }

    @Override
    public void onTypeVisibilityChange() {
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        EventTypeDescriptorRepository repo = new EventTypeDescriptorRepository();
        for (DataSeriesDescriptor dsd : this.getChartDescriptor().getLeftYAxis().getDataSeries()) {
            EventTypeDescriptorRepository etr = FLRDescriptorToolkit.getEventTypeRepository(dsd);
            repo.getDescriptors().addAll(etr.getDescriptors());
            if (!etr.getUserFilterConstrained()) continue;
            repo.setUserFilterConstrained(true);
        }
        return repo;
    }
}

