/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.alert.AlertObject;
import com.jrockit.mc.alert.AlertPlugin;
import com.jrockit.mc.alert.NotificationUIToolkit;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.notification.action.Messages;
import com.jrockit.mc.console.ui.notification.action.TriggerActionJFRToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import com.jrockit.mc.rjmx.triggers.IActivatableTriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.ui.MCPathEditorInput;
import com.jrockit.mc.ui.WorkbenchToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPathEditorInput;

public class TriggerActionStartTimeBoundJFR
extends TriggerAction
implements IActivatableTriggerAction {
    public static final int MAX_CONTINUOUS_ERROR_COUNT = 10;
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            ConsolePlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        this.startTimeBoundJFR(service, event);
    }

    private void startTimeBoundJFR(IFlightRecorderService service, TriggerEvent event) throws FlightRecorderException {
        long millis = this.getSetting("timerange").getLong();
        RecordingOptionsBuilder b = new RecordingOptionsBuilder();
        b.duration(millis);
        String name = this.getSetting("name").getString();
        if (++this.recordingNumber > 1) {
            name = String.valueOf(name) + " " + this.recordingNumber;
        }
        b.name(name);
        MCFile path = IDESupportToolkit.createFileResource((String)this.getSetting("file").getFileName());
        IRecordingDescriptor descriptor = service.start(b.build(), TriggerActionJFRToolkit.getTemplate("Profiling", service));
        boolean open = this.getSetting("open").getBoolean();
        if (!descriptor.isContinuous()) {
            new WaitAndOpenJob(service, descriptor, event, path, open).schedule(millis);
        }
    }

    private File dumpFile(IProgressMonitor monitor, IFlightRecorderService service, IRecordingDescriptor descriptor, MCFile path) throws IOException, FlightRecorderException {
        InputStream stream = service.openStream(descriptor, false);
        try {
            File file = IDESupportToolkit.writeToUniqueFile((MCFile)path, (InputStream)stream, (IProgressMonitor)monitor);
            return file;
        }
        finally {
            IOToolkit.closeSilently((Closeable)stream);
        }
    }

    private void showAlert(File file, TriggerEvent event) {
        AlertObject ao = new AlertObject(event.getCreationTime(), event.getSource(), event.getRule(), NotificationUIToolkit.prettyPrint((TriggerEvent)event, (String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_MESSAGE_RECORDING_SUCCESSFUL_PATH, (Object)file.getPath())), null);
        AlertPlugin.getDefault().addAlertObject(ao);
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return TriggerActionJFRToolkit.supportsJFRAction(handle);
    }

    public boolean isActivatable(IConnectionHandle handle) {
        return TriggerActionJFRToolkit.isActivatableJFRAction(handle);
    }

    private class WaitAndOpenJob
    extends Job {
        private final IFlightRecorderService m_service;
        private IRecordingDescriptor m_descriptor;
        private final MCFile m_path;
        private int m_updateErrorCount;
        private boolean m_open;
        private TriggerEvent m_event;

        public WaitAndOpenJob(IFlightRecorderService service, IRecordingDescriptor descriptor, TriggerEvent event, MCFile path, boolean open) {
            super(descriptor.getName());
            this.m_updateErrorCount = 0;
            this.m_service = service;
            this.m_descriptor = descriptor;
            this.m_event = event;
            this.m_path = path;
            this.m_open = open;
        }

        protected IStatus run(IProgressMonitor monitor) {
            block8: {
                try {
                    this.m_descriptor = this.m_service.getUpdatedRecordingDescription(this.m_descriptor);
                    this.m_updateErrorCount = 0;
                }
                catch (FlightRecorderException e) {
                    ConsolePlugin.getDefault().getLogger().severe("Problem updating a flight recording on the " + this.m_descriptor.getName() + " JVM");
                    if (++this.m_updateErrorCount <= 10) break block8;
                    return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_UPDATE_STATUS_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
                }
            }
            if (this.m_descriptor.getState() != IRecordingDescriptor.RecordingState.STOPPED) {
                this.schedule(1000L);
                return Status.OK_STATUS;
            }
            try {
                File writtenFile = TriggerActionStartTimeBoundJFR.this.dumpFile(monitor, this.m_service, this.m_descriptor, this.m_path);
                if (this.m_open) {
                    WorkbenchToolkit.asyncOpenEditor((IPathEditorInput)new MCPathEditorInput(writtenFile));
                } else {
                    TriggerActionStartTimeBoundJFR.this.showAlert(writtenFile, this.m_event);
                }
                return StatusFactory.createOk((String)NLS.bind((String)Messages.WriteAndOpenRecordingJob_MESSAGE_SUCCESSFUL_DUMP, (Object)this.m_descriptor.getName()));
            }
            catch (FlightRecorderException e) {
                return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_SERVICE_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
            catch (IOException e) {
                return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerActionStartTimeBoundJFR_IO_ERROR_MSG, (Object)this.m_descriptor.getName()), (Throwable)e, (boolean)false);
            }
        }
    }
}

