/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.components.ui.behaviors.IStatusListener;
import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.ComboInput;
import com.jrockit.mc.components.ui.settings.CompositeInput;
import com.jrockit.mc.components.ui.settings.IInput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.widgets.Composite;

public final class UnitInput
extends CompositeInput {
    private final ComboInput m_contentTypeCombo = new ComboInput("contentType", Messages.UNIT_INPUT_CONTENT_TYPE_INPUT_TEXT);
    private final ComboInput m_displayTypeCombo = new ComboInput("displayUnit", Messages.UNIT_INPUT_DISPLAY_UNIT_INPUT_TEXT);
    private final String m_key;

    public UnitInput(String key, boolean showTimeBased) {
        this.m_key = key;
        this.addInput(this.m_contentTypeCombo);
        this.addInput(this.m_displayTypeCombo);
        if (showTimeBased) {
            this.addInput(new BooleanInput("derivative", Messages.UNIT_INPUT_USE_TIME_DERIVATE_TEXT));
        }
        this.hookContentTypeChange();
    }

    @Override
    public void setSetting(Setting setting) {
        super.setSetting(setting == null ? null : setting.getChild(this.m_key));
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        for (IInput i : this.getInputs()) {
            i.create(parent, horizontalSpan);
        }
    }

    @Override
    public void refresh() {
        if (this.m_contentTypeCombo.isEnabled()) {
            this.m_contentTypeCombo.setItems(UnitLookup.createContentTypeMap());
            this.m_contentTypeCombo.refresh();
            this.refreshDisplayUnit();
        }
    }

    private void refreshDisplayUnit() {
        ContentType ct = UnitLookup.getContentType((String)this.m_contentTypeCombo.getSelectedKey());
        this.m_displayTypeCombo.setItems(ct.createDisplayUnitMap());
        this.m_displayTypeCombo.refresh();
    }

    private void hookContentTypeChange() {
        this.m_contentTypeCombo.addStatusListener(new IStatusListener(){

            @Override
            public void onChange(IStatus status) {
                if (status == IInput.STATUS_SETTING_CHANGE) {
                    UnitInput.this.refreshDisplayUnit();
                }
            }
        });
    }
}

